$fn=360;

// Led strips measurements
stripLength=50;
stripWidth=8.15;
stripTip2centerOfChosenLed=24.88;
stripPlusLedThickness=2.0;

// light pipe measurements
lpDiam=3.15;
lpLensDiam=4.18;
lpLensLength=13.15;
lpLensCapDiam=5.1;
lpLensCapThickness=1.0;

// Some desired values
tolerance=0.4
;
wallThickness=3.0;
ElectricWiresHoleDiam=4;



boxL=stripLength+2*(wallThickness+tolerance);
boxW=stripWidth+2*(wallThickness+tolerance);
boxH=stripPlusLedThickness+lpLensLength+lpLensCapThickness+2*(wallThickness+tolerance);

module openBox(l,w, h, t, whd){
    difference(){
        translate([-l/2,-w/2,0])cube([l,w,h]);
        translate([-l/2+t,-w/2+t,t])cube([l-2*t,w-2*t,h]);
        translate([-l/8,-w/2+t,h-t/2])
            rotate([0,90,0])
               cylinder(h=l/4,d=t/2);
        translate([-l/8,w/2-t,h-t/2])
            rotate([0,90,0])
               cylinder(h=l/4,d=t/2);
        translate([-l/2+t,-w/8, h-t/2])
            rotate([-90,0,0])
                cylinder(h=w/4,d=t/2);
        translate([l/2-t,-w/8, h-t/2])
            rotate([-90,0,0])
                cylinder(h=w/4,d=t/2);        
        translate([-l/2-1,0,h/2])
            rotate([0,90,0])
                cylinder(h=l+2, d=whd);
    }    
}

module cover(l,w,t,wd,ld,lh,cd,ch,st2cocl){
    difference(){
        union(){
            cube([l,w,t]);
            translate([st2cocl-cd,0,t])cube([cd*2,w,lh+ch]);
            translate([l/2-l/8,0,t/2])rotate([0,90,0])
                cylinder(h=l/4,d=t/2);
            translate([l/2-l/8,w,t/2])rotate([0,90,0])
                cylinder(h=l/4,d=t/2);
            translate([0,w/2-w/8,t/2])rotate([-90,0,0])
                cylinder(h=w/4,d=t/2);
            translate([l,w/2-w/8,t/2])rotate([-90,0,0])
                cylinder(h=w/4,d=t/2);
        }
        translate([st2cocl,w/2,-1])cylinder(d=wd,h=lh+ch+t+2);
        translate([st2cocl,w/2,t])cylinder(d=ld,h=lh+ch+1);
        translate([st2cocl,w/2,t+lh])cylinder(d=cd,h=ch+1);
    }
}

openBox(boxL,boxW,boxH,wallThickness,ElectricWiresHoleDiam);
translate([-boxL/2+wallThickness,-boxW*1.5,0])
    cover(stripLength,
          stripWidth,
          wallThickness,
          lpDiam+tolerance,
          lpLensDiam+tolerance,
          lpLensLength,
          lpLensCapDiam+tolerance,
          lpLensCapThickness,
          stripTip2centerOfChosenLed
          );


