$fn=360;


verticalClearance=4.0;
opaqueWallThickness=2.0;
// Set the the value of f
// according to the required
// film format:
// 0=35mm
// 1=16mm
// 2=8mm
// 3=super8
// 4=pathex9.5
// 5=Out of specs 8mm
f=1;

formatName=(f == 0) ? "35mm"  :
           (f == 1) ? "16mm"  :
           (f == 2) ? "8mm"   :
           (f == 3) ? "Super8":
           (f == 4) ? "Pathex": 
           (f == 5) ? "8.4mm" : "?";
           
filmWidth= (f == 0) ? 35.0 :
           (f == 1) ? 16.0 :
           (f == 2) ?  7.9 :
           (f == 3) ?  7.9 :
           (f == 4) ?  9.5 :
           (f == 5) ?  8.4 : 0;

frameMax=  (f == 0) ? 18.999:
           (f == 1) ? 7.55  :
           (f == 2) ? 3.81  :
           (f == 3) ? 4.23  : 
           (f == 4) ? 7.54  : 
           (f == 5) ? 3.81  : 0;
           
HoleHeight= (f == 0) ? 1.95 :
            (f == 1) ? 1.27 :
            (f == 2) ? 1.23 :
            (f == 3) ? 1.14 :
            (f == 4) ? 2.0  : 
            (f == 5) ? 1.23 : 0;

edgeToHoleCenter= (f == 0) ? 3.4155 :
                  (f == 1) ? 1.8    :
                  (f == 2) ? 1.8    :
                  (f == 3) ? 0.965  :
                  (f == 4) ? 4.75   :
                  (f == 5) ? 1.84   : 0;
                  
BackOfHoleDiam= (f == 0) ? 6   :
                (f == 1) ? 5   :
                (f == 2) ? 5   :
                (f == 3) ? 4.5 : 
                (f == 4) ? 5   :
                (f == 5) ? 5   :0;
                

detectorOffset= (f == 0) ? 27.25  :
                (f == 1) ? 19.75  :
                (f == 2) ? 17.145 :
                (f == 3) ? 19.035 :
                (f == 4) ? 19.75  :
                (f == 5) ? 17.145 : 0;

// Smaller for Super8
pinHoleDiam= (f==3) ? 0.6 : 0.8;
             
// only 16mm needs at bottom
holeAtBottom= (f==1) ? 1 : 0;


ExternalDiam=200;



spillTrackWidth=0.5;


minimumDetectorOffset=frameMax/2.0+verticalClearance+opaqueWallThickness+HoleHeight/2.0;

//desired values
filmTolerance=0.33; // FDM
mechanicalTolerance=0.5; // FDM
lightPipeTolerance=0.3; // FDM
//filmTolerance=0.15; // resin
//mechanicalTolerance=0.3; // resin
//lightPipeTolerance=0.2; // resin
curvedPartHeight=43.0;
GateWidth=80.0;
thicknessMax=8.0;
FilmCavity=3.25;
spillTrackDepth=1.0;
Borders=(curvedPartHeight-filmWidth)/2.0;
baseHeight=4.0;
baseDepth=22;
topDepth=baseDepth;
lightPipeDiam=2.2;
pipeHolderW=8;
pipeHolderL=pipeHolderW*2;
pipeHolderH=curvedPartHeight+2*baseHeight;
echo (formatName);




echo ("minimumDetectorOffset");
echo (minimumDetectorOffset);
minimumNumberOfHoles=round(minimumDetectorOffset/(frameMax/4.0)+0.5);
echo ("minimumNumberOfHoles");
echo (minimumNumberOfHoles);
//detectorOffset=minimumNumberOfHoles*(frameMax/4.0)+InBetweenHoles/2.0+HoleHeight;
angleOffset=360*detectorOffset/((ExternalDiam-FilmCavity)*PI);
echo ("detectorOffset");
echo (detectorOffset);
echo ("angleOffset");
echo (angleOffset);


module roundedSurface(thickness, height, width){
    linear_extrude(height=height){
        intersection(){
            translate([-ExternalDiam/2.0+1.0,-width/2.0,0])
                square([ExternalDiam/2.0+1.0+2.0,width]);
            translate([-ExternalDiam/2.0,0,0])
                difference(){
                    circle(d=ExternalDiam-thicknessMax+thickness);
                    circle(d=ExternalDiam-thicknessMax);
                }
        }
    }
    
}

module theSevenParts(){
    translate([-topDepth+3,-GateWidth/2,-baseHeight])
        cube([baseDepth,GateWidth,baseHeight]);
    roundedSurface(thicknessMax, Borders,GateWidth);
    translate([0,0,Borders]) 
        roundedSurface(thicknessMax-FilmCavity-spillTrackDepth,spillTrackWidth,GateWidth);
    translate([0,0,Borders+spillTrackWidth]) 
        roundedSurface(thicknessMax-FilmCavity,filmWidth+filmTolerance-2*spillTrackWidth,GateWidth);
    translate([0,0,Borders+filmWidth+filmTolerance-spillTrackWidth]) 
        roundedSurface(thicknessMax-FilmCavity-spillTrackDepth,spillTrackWidth,GateWidth);
    translate([0,0,Borders+filmWidth+filmTolerance])
        roundedSurface(thicknessMax, Borders,GateWidth);
    translate([-topDepth+3,-GateWidth/2,curvedPartHeight])
        cube([topDepth,GateWidth,baseHeight]);
}

module Holes(){
    backHoleHeight= (holeAtBottom == 0) ? 
        Borders+filmWidth+filmTolerance/2.0-edgeToHoleCenter :
        Borders+filmTolerance/2.0+edgeToHoleCenter;
    translate([-baseDepth+1,-(frameMax+2*verticalClearance)/2.0,Borders-0.5])
        cube([baseDepth+2.0,frameMax+2*verticalClearance,filmWidth+filmTolerance+1]);
    translate([-ExternalDiam/2.0,0,backHoleHeight])rotate([0,0,angleOffset]){
        rotate([0,90,0])cylinder(d=BackOfHoleDiam,h=ExternalDiam/2.0+2);
    }
    translate([-ExternalDiam/2.0,0,0])rotate([0,0,angleOffset])translate([ExternalDiam/2.0,0,0])pipeHolderMat(pipeHolderW+mechanicalTolerance,pipeHolderL+mechanicalTolerance,pipeHolderH);
    translate([-4,-33,curvedPartHeight+baseHeight-1])rotate([0,0,90])linear_extrude(height=2)text(formatName,size=8);
}


module oneHole(){
    translate([0,0,-3])cylinder(d=pinHoleDiam,h=20);
    translate([0,0,3.5])cylinder(d=lightPipeDiam+lightPipeTolerance,h=20);
}

module pipeHoles(){
    h= (holeAtBottom==0) ?
        Borders+filmWidth+filmTolerance/2.0-edgeToHoleCenter:
        Borders+filmTolerance/2.0+edgeToHoleCenter;
    
    translate([-1.2,0,h])
    {
        rotate([0,45,0])oneHole();
        rotate([0,135,0])oneHole();
    }
    translate([6,2,pipeHolderH+pipeHolderW-1])rotate([0,0,180])linear_extrude(height=2)text(formatName,size=3.8);
}

module pipeHolderMat(w,l,h){
    b=4.7;
    translate([-0.7,-l/2.0,0])cube([w,l,h]);            
    translate([w/2-0.7,0,-baseHeight/2.0])cylinder(d1=w/8.0,d2=w/4,h=baseHeight/2.0);
    translate([-b-w,-l/2.0,0])cube([w,l,h]);
    translate([-b-w/2.0,0,-baseHeight/2.0])cylinder(d1=w/8.0,d2=w/2.0,h=baseHeight/2.0);
    translate([-b-w,-l/2.0,h])cube([2.0*w+b-0.7,l,w]);
}


module pipeHolder(w,l,h){
    difference(){
        pipeHolderMat(w,l,h);
        pipeHoles();
    }
}


// HOLE SENSOR
rotate([90,0,0])translate([-ExternalDiam/2.0+20,-11,-30])translate([ExternalDiam/2.0,0,0])
   pipeHolder(pipeHolderW,pipeHolderL,pipeHolderH);

// GATE
rotate([0,-90,0])difference(){
    theSevenParts();
    Holes();
}
